#include <QtGui>
#include "Langas.h"
#include <fstream>

using namespace std;
ofstream file("aa.txt");

Langas::Langas(QWidget *parent)
{
   setWindowTitle("Piesimas");

   int width = 700;
   int height = 500;

   setFixedSize(width, height);
   move(250,150);
}

void Langas::setKoordinates(string koordinates2)
{
   koordinates = getKoordinetesArray(koordinates2);
   this->update();
}
    
taskaiVector Langas::getKoordinetesArray(string koordinates2)
{
   stringVector koordinates3;
   Tokenize(koordinates2, koordinates3, "&");
   viso = koordinates3.size();
   taskaiVector taskai;
   int x = 0, y = 0;
   QColor color = Qt::lightGray;

   for(int i=0;i<viso;i++)
   {
      stringVector tmp;
      Tokenize(koordinates3[i], tmp, " ");

      x = atoi(tmp[0].c_str());
      y = atoi(tmp[1].c_str());

      int colorInt = atoi(tmp[2].c_str());
      if(colorInt == 1)
      {
         color = Qt::black;
      }
      else
      {
         color = Qt::lightGray;
      }

      taskai.push_back(new Taskas(x, y, color));
   }

   return taskai;
}

void Langas::paintEvent(QPaintEvent *event)
{
   QPainter painter(this);
   painter.setBrush(Qt::lightGray);
   painter.drawRect(0, 0, 700, 500);
   for(int i=1;i<viso;i++)
   {
      painter.setPen(koordinates[i]->color);
      painter.drawLine(koordinates[i-1]->x, koordinates[i-1]->y, koordinates[i]->x, koordinates[i]->y);
   }
   
}

void Langas::Tokenize(const string& str, stringVector& tokens, const string& delimiters)
{
   // Skip delimiters at beginning.
   string::size_type lastPos = str.find_first_not_of(delimiters, 0);
   // Find first "non-delimiter".
   string::size_type pos = str.find_first_of(delimiters, lastPos);

   while (string::npos != pos || string::npos != lastPos)
   {
      // Found a token, add it to the vector.
      tokens.push_back(str.substr(lastPos, pos - lastPos));
      // Skip delimiters.  Note the "not_of"
      lastPos = str.find_first_not_of(delimiters, pos);
      // Find next "non-delimiter"
      pos = str.find_first_of(delimiters, lastPos);
   }
}
